% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/googleAuthR_shiny.R
\name{reactiveAccessToken}
\alias{reactiveAccessToken}
\title{Create a reactive Google OAuth2 token}
\usage{
reactiveAccessToken(session)
}
\arguments{
\item{session}{A Shiny session object.}
}
\value{
A reactive Google auth token
}
\description{
Use within a Shiny server.R session to create the access token passed
  to all Google API functions using \code{with_shiny}
}
\examples{
\dontrun{
## in global.R

## create the API call function, example with goo.gl URL shortner
library(googleAuthR)
options("googleAuthR.scopes.selected" = c("https://www.googleapis.com/auth/urlshortener"))

shorten_url <- function(url){

  body = list(
    longUrl = url
 )

 f <- gar_api_generator("https://www.googleapis.com/urlshortener/v1/url",
                        "POST",
                        data_parse_function = function(x) x$id)

 f(the_body = body)

 }


## in server.R
library(shiny)
library(googleAuthR)
source('global.R')

shinyServer(function(input, output, session)){

  ## Get auth code from return URL
  access_token  <- reactiveAccessToken(session)

  ## Make a loginButton to display using loginOutput
  output$loginButton <- renderLogin(session, access_token())

  short_url_output <- eventReactive(input$submit, {
  ## wrap existing function with_shiny
  ## pass the reactive token in shiny_access_token
  ## pass other named arguments
    short_url <- with_shiny(f = shorten_url,
                           shiny_access_token = access_token(),
                           url=input$url)

   })

   output$short_url <- renderText({

     short_url_output()

   })
 }

## in ui.R
library(shiny)
library(googleAuthR)

shinyUI(
  fluidPage(
    loginOutput("loginButton"),
    textInput("url", "Enter URL"),
    actionButton("submit", "Shorten URL"),
    textOutput("short_url")
    ))
}
}
\seealso{
Other shiny auth functions: \code{\link{authReturnCode}};
  \code{\link{createCode}};
  \code{\link{gar_shiny_getAuthUrl}};
  \code{\link{gar_shiny_getToken}};
  \code{\link{gar_shiny_getUrl}};
  \code{\link{loginOutput}}; \code{\link{renderLogin}};
  \code{\link{with_shiny}}
}

