% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googleAuthR_auto_auth.R
\name{gar_auto_auth}
\alias{gar_auto_auth}
\title{Perform auto authentication}
\usage{
gar_auto_auth(required_scopes, new_user = FALSE, no_auto = FALSE,
  environment_var = "GAR_AUTH_FILE",
  travis_environment_var = "TRAVIS_GAR_AUTH_FILE")
}
\arguments{
\item{required_scopes}{Required scopes needed to authenticate - needs to match at least one}

\item{new_user}{If TRUE, reauthenticate via Google login screen}

\item{no_auto}{If TRUE, ignore auto-authentication settings}

\item{environment_var}{Name of environment var that contains auth file path}

\item{travis_environment_var}{Name of Travis environment var that contains auth file path

The authentication file can be a \code{.httr-oauth} file created via \link{gar_auth} or a Google service JSON file downloaded from the Google API crudential console, with file extension \code{.json}.

You can use this in your code to authenticate from a filelocation specified in in file, but it is mainly intended to be called on package load via \link{gar_attach_auto_auth}.


\code{environment_var} This is the name that will be called via \link{Sys.getenv} on library load.  The environment variable will contain an absolute file path to the location of an authentication file.

\code{travis_environment_var} Name that will be called via \link{Sys.getenv} in Travis tests.  
  As the working directory is different on travis, 
  this environment variable should contain a relative path to your Github repository home folder.}
}
\value{
an OAuth token object, specifically a
  \code{\link[=Token-class]{Token2.0}}, invisibly
}
\description{
This helper function lets you use environment variables to auto-authenticate on package load, intended for calling by \link{gar_attach_auto_auth}
}
\seealso{
Help files for \link{.onAttach}

Other authentication functions: \code{\link{gar_attach_auto_auth}},
  \code{\link{gar_auth_service}}, \code{\link{gar_auth}},
  \code{\link{gar_gce_auth}},
  \code{\link{get_google_token}},
  \code{\link{is_legit_token}}, \code{\link{token_exists}}
}
