% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_wizard.R
\name{gar_setup_menu_do}
\alias{gar_setup_menu_do}
\title{Setup wizard help - the functions that will execute on different menu options}
\usage{
gar_setup_menu_do(menu_option, trigger, do_function, stop = FALSE, ...)
}
\arguments{
\item{menu_option}{The menu option chosen from \link{menu} or \link{gar_setup_menu}}

\item{trigger}{What option will trigger the \code{do_function}}

\item{do_function}{The function in the same order as the menu options}

\item{stop}{Whether to stop and exit if the function comes back FALSE}

\item{...}{arguments passed to \code{do_function}}
}
\value{
FALSE if setting was not set, TRUE if it was
}
\description{
Setup wizard help - the functions that will execute on different menu options
}
\details{
The functions should come back with TRUE or FALSE depending on if the setting was successful.
}
\examples{

\dontrun{

op <- gar_setup_menu(c("Check all settings",
                       "Configure authentication",
                       "Configure env arg 1",
                       "Configure env arg 2",
                       "Configure something else"
                       ),
                       package_name = "googleAuthR")
                       
choice <- gar_setup_check_session()

custom_env_check_f <- function(choice){
  r <- readline("project-id:")
  gar_setup_env_check("ARG2", 
                      set_to = r, 
                      edit_option = choice == 1, #allow editing of env arg
                      session_user = choice)
  TRUE
}

gar_setup_menu_do(op, c(1,2), my_setup_auth_f, stop = TRUE)
gar_setup_menu_do(op, c(1,3), gar_setup_env_check, 
                  env_arg = "ARG1", set_to = "BLAH", 
                  edit_option = choice == 1, #allow editing of env arg
                  session_user = choice)
gar_setup_menu_do(op, c(1,4), custom_env_check_f)
gar_setup_menu_do(op, c(1,4), my_setup_something_f)

}
}
\seealso{
Other setup functions: 
\code{\link{gar_setup_auth_check}()},
\code{\link{gar_setup_auth_key}()},
\code{\link{gar_setup_clientid}()},
\code{\link{gar_setup_edit_renviron}()},
\code{\link{gar_setup_env_check}()},
\code{\link{gar_setup_menu}()}
}
\concept{setup functions}
