% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{gcs_copy_object}
\alias{gcs_copy_object}
\title{Copy an object}
\usage{
gcs_copy_object(source_object, destination_object,
  source_bucket = gcs_get_global_bucket(),
  destination_bucket = gcs_get_global_bucket(), rewriteToken = NULL,
  destinationPredefinedAcl = NULL)
}
\arguments{
\item{source_object}{The name of the object to copy, or a \code{gs://} URL}

\item{destination_object}{The name of where to copy the object to, or a \code{gs://} URL}

\item{source_bucket}{The bucket of the source object}

\item{destination_bucket}{The bucket of the destination}

\item{rewriteToken}{Include this field (from the previous rewrite response) on each rewrite request after the first one, until the rewrite response 'done' flag is true.}

\item{destinationPredefinedAcl}{Apply a predefined set of access controls to the destination object. If not NULL must be one of the predefined access controls such as \code{"bucketOwnerFullControl"}}
}
\value{
If successful, a rewrite object.
}
\description{
Copies an object to a new destination
}
\seealso{
Other object functions: \code{\link{gcs_compose_objects}},
  \code{\link{gcs_delete_object}},
  \code{\link{gcs_get_object}},
  \code{\link{gcs_list_objects}},
  \code{\link{gcs_metadata_object}}
}
\concept{object functions}
