% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt.R
\name{wkt_polyline}
\alias{wkt_polyline}
\title{WKT Polyline}
\usage{
wkt_polyline(obj)
}
\arguments{
\item{obj}{\code{sfencoded} object or \code{wkt_column} of well-known text}
}
\value{
encoded polyline representation of geometries
}
\description{
Converts well-known text into encoded polylines.
}
\details{
'Polylines' refers to lat/lon coordinates encoded into strings using Google's 
polyline encoding algorithm.
}
\examples{
\dontrun{

library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))

## encode to polylines
enc <- encode(nc)

## convert encoded lines to well-known text
wkt <- polyline_wkt(enc)

## convert well-known text back to polylines
enc2 <- wkt_polyline(wkt)

}

}
