% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_mime_type.R
\name{drive_extension}
\alias{drive_extension}
\title{Lookup extension from MIME type}
\usage{
drive_extension(type = NULL)
}
\arguments{
\item{type}{Character. MIME type or file extension.}
}
\value{
Character. File extension.
}
\description{
This is a helper to determinine which extension should be used
for a file. Two types of input are acceptable:
\itemize{
\item MIME types accepted by Google Drive.
\item File extensions, such as "pdf", "csv", etc. (these are simply passed through).
}
}
\examples{

## get the extension for mime type image/jpeg
drive_extension("image/jpeg")

## it's vectorized
drive_extension(c("text/plain", "pdf", "image/gif"))
}
