% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_circle.R
\name{update_circles}
\alias{update_circles}
\title{Update circles}
\usage{
update_circles(map, data, id, radius = NULL, draggable = NULL,
  stroke_colour = NULL, stroke_weight = NULL, stroke_opacity = NULL,
  fill_colour = NULL, fill_opacity = NULL, info_window = NULL,
  layer_id = NULL, digits = 4, palette = NULL, legend = F,
  legend_options = NULL)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least two columns, one specifying the
latitude coordinates, and the other specifying the longitude. If Null, the
data passed into \code{google_map()} will be used.}

\item{id}{string representing the column of \code{data} containing the id values
for the shapes. The id values must be present in the original data supplied to in order
for the shape to be udpated.}

\item{radius}{either a string specifying the column of \code{data} containing the
radius of each circle, OR a numeric value specifying the radius of all the circles
(radius is expressed in metres)}

\item{draggable}{string specifying the column of \code{data} defining if
the polygon is 'draggable'. The column of data should be logical (either TRUE or FALSE)}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each shape, or a number indicating the width of pixels
in the line to be applied to all the shapes}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each shape, or a value between 0 and 1 that will be
applied to all the shapes}

\item{fill_colour}{either a string specifying the column of \code{data} containing
the fill colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{fill_opacity}{either a string specifying the column of \code{data} containing
the fill opacity of each shape, or a value between 0 and 1 that will be applied
to all the shapes}

\item{info_window}{string specifying the column of data to display in an info
window when a shape is clicked.}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers for when using any \code{update_} function, and
for separating legends.}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{palette}{a function, or list of functions, that generates hex colours
given a single number as an input. See details.}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}
}
\description{
Updates specific colours and opacities of specified circles Designed to be
used in a shiny application.
}
\note{
Any circles (as specified by the \code{id} argument) that do not exist
in the \code{data} passed into \code{add_circles()} will not be added to the map.
This function will only update the circles that currently exist on the map when
the function is called.
}
