% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcc.R
\name{hcc}
\alias{hcc}
\title{Estimation of Standard Heterosis.}
\usage{
hcc(hybrid, check)
}
\arguments{
\item{hybrid}{Data set containing the mean values of experimental genotypes.}

\item{check}{Data set containing the mean values of commercial checks.}
}
\value{
\item{\code{Standard Heterosis}}{A data set containing per cent Standard heterosis between experimental genotypes and checks for all the variables.}
}
\description{
Estimation of Standard Heterosis.
}
\details{
Estimating Standard heterosis between mean values of experimental genotypes and commercial checks.
}
\note{
The name of variables in both the data sets should be identical.
}
\examples{
\dontrun{# Standard Heterosis
library(gpbStat)
data(hybrid)
data(check)
df = hcc(hybrid, check)
df
}
}
\references{
Singh, R. K. and Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis. Kalyani Publishers, New Delhi.
}
\seealso{
\code{\link[gpbStat]{ltcchk}}\code{\link[gpbStat]{ltc}}
}
\author{
Nandan Patil \email{patilnads@gmail.com}
}
