% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.interprete.R
\name{gpb.interprete}
\alias{gpb.interprete}
\title{Compute feature contribution of prediction}
\usage{
gpb.interprete(model, data, idxset, num_iteration = NULL)
}
\arguments{
\item{model}{object of class \code{gpb.Booster}.}

\item{data}{a matrix object or a dgCMatrix object.}

\item{idxset}{an integer vector of indices of rows needed.}

\item{num_iteration}{number of iteration want to predict with, NULL or <= 0 means use best iteration.}
}
\value{
For regression, binary classification and lambdarank model, a \code{list} of \code{data.table}
        with the following columns:
        \itemize{
            \item{\code{Feature}: Feature names in the model.}
            \item{\code{Contribution}: The total contribution of this feature's splits.}
        }
        For multiclass classification, a \code{list} of \code{data.table} with the Feature column and
        Contribution columns to each class.
}
\description{
Computes feature contribution components of rawscore prediction.
}
\examples{
\donttest{
Logit <- function(x) log(x / (1.0 - x))
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
setinfo(dtrain, "init_score", rep(Logit(mean(train$label)), length(train$label)))
data(agaricus.test, package = "gpboost")
test <- agaricus.test

params <- list(
    objective = "binary"
    , learning_rate = 0.1
    , max_depth = -1L
    , min_data_in_leaf = 1L
    , min_sum_hessian_in_leaf = 1.0
)
model <- gpb.train(
    params = params
    , data = dtrain
    , nrounds = 3L
)

tree_interpretation <- gpb.interprete(model, test$data, 1L:5L)
}
}
