% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{grouped}
\alias{grouped}
\title{Grouped operator}
\usage{
grouped(f, ...)
}
\arguments{
\item{f}{A function.}

\item{...}{Deprecated. Additional arguments to \code{f} that should \emph{not} be
treated as grouped.}
}
\value{
A function like \code{f} with a new argument \code{group}. This accepts a factor to
split all other arguments in \code{f} into groups before applying \code{f} to each
group and combining the results. It is similar to \code{\link[=ave]{ave()}}, but more general.
}
\description{
Make a function applicable to grouped data.
}
\examples{
p1 <- price6[[3]]
p0 <- price6[[2]]
q1 <- quantity6[[3]]
q0 <- quantity6[[2]]

# Calculate Tornqvist weights for two groups

f <- factor(rep(letters[1:2], each = 3))
tornqvist_weights <- grouped(index_weights("Tornqvist"))
tornqvist_weights(p1, p0, q1, q0, group = f)

# Calculate a mean like ave(), but with weights

x <- 1:6
w <- c(1:5, NA)
grouped_mean <- grouped(\(x, w) geometric_mean(x, w, na.rm = TRUE))
grouped_mean(x, w, group = f)

# Redistribute weights

w1 <- c(2, 4)
w2 <- 1:6

harmonic_mean(mapply(harmonic_mean, split(x, f), split(w2, f)), w1)

wr <- grouped(scale_weights)(w2, group = f) * w1[f]
harmonic_mean(x, wr)

}
\seealso{
Other operators: 
\code{\link{balanced}()},
\code{\link{quantity_index}()}
}
\concept{operators}
