% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveload.R
\name{gp_saveload}
\alias{gp_saveload}
\alias{gp_save}
\alias{gp_load}
\title{Save and load a GP model}
\usage{
gp_save(gp, filename)

gp_load(filename)
}
\arguments{
\item{gp}{The gp model object to be saved.}

\item{filename}{Where to save or load from.}
}
\value{
\code{gp_load} returns the loaded GP model object.
}
\description{
Convenience functions for saving and loading GP models.
}
\examples{

gp <- gp_init()

# fit the model (skipped here)

# save the model
filename <- file.path(tempdir(), 'gp.rda')
gp_save(gp, filename)

# load the model and remove the file
gp <- gp_load(filename)
file.remove(filename)


}
