% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{vcov.GPPM}
\alias{vcov.GPPM}
\title{Variance-Covariance Matrix}
\usage{
\method{vcov}{GPPM}(object, ...)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{...}{additional arguments (currently not used).}
}
\value{
A matrix of the estimated covariances between the parameter estimates. This has row and column names corresponding to the parameter names.
}
\description{
Returns the variance-covariance matrix of the parameters of a fitted GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
lgcmFit <- fit(lgcm)
covMat <- vcov(lgcmFit)
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{covf}}, \code{\link{datas}},
  \code{\link{fitted.GPPM}}, \code{\link{getIntern}},
  \code{\link{logLik.GPPM}}, \code{\link{maxnObs}},
  \code{\link{meanf}}, \code{\link{nObs}},
  \code{\link{nPars}}, \code{\link{nPers}},
  \code{\link{nPreds}}, \code{\link{parEsts}},
  \code{\link{pars}}, \code{\link{preds}}
}
