% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{publish_gostplot}
\alias{publish_gostplot}
\title{Create and save an annotated Manhattan plot of enrichment results.}
\usage{
publish_gostplot(p, highlight_terms = NULL, filename = NULL)
}
\arguments{
\item{p}{ggplot object from gostplot(gostres, interactive = FALSE) function}

\item{highlight_terms}{vector of selected term IDs from the analysis or a (subset) data.frame that has a column called 'term_id'. No annotation is added if set to NULL.}

\item{filename}{file name to create on disk and save the annotated plot. Filename extension should be from c("png", "pdf", "jpeg", "tiff", "bmp").}
}
\value{
The output is a ggplot object.
}
\description{
This function allows to highlight a list of selected terms on the Manhattan plot created with the gprofiler2::gostplot() function.
The resulting plot is saved to a publication ready image if 'filename' is specified.
The plot is very similar to the one shown in the g:GOSt web tool after clicking on circles.
}
\examples{
 gostres <- gost(c("Klf4", "Pax5", "Sox2", "Nanog"), organism = "mmusculus")
 p <- gostplot(gostres, interactive = FALSE)
 publish_gostplot(p, highlight_terms = c("GO:0001010", "WP:WP1763"))
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>
}
