% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-Schema.R
\name{Schema}
\alias{Schema}
\title{GraphQL Schema object}
\description{
Manages a GraphQL schema definition.  A Schema can add more GraphQL type definitions, assist in determining definition types, retrieve particular definitions, and can combine with other schema definitions.

Typically, Schema class objects are created using \code{\link{gqlr_schema}}.  Creating a \code{Schema$new()} object should be reserved for when multiple Schema objects are combined.
}
\section{Usage}{

\preformatted{
## using star_wars_schema from
# example(gqlr_schema)
star_wars_schema$get_schema()
star_wars_schema$is_enum("Episode") # TRUE
star_wars_schema$is_object("Episode") # FALSE
execute_request("{ hero { name } }", star_wars_schema)
}
}

\section{Initialize}{

\describe{
  \item{schema}{Either a character GraphQL definition of a schema or another Schema object.  Extending methods and descriptions should be added with \code{gqlr_schema}}.
}

 The initialize function will automatically add \itemize{
   \item{Scalars: Int, Float, String, Boolean}
   \item{Directives: @skip and @include}
   \item{Introspection Capabilities}
 }
}

\section{Details}{

\code{$add(obj)}: function to add either another Schema's definitions or Document of definitions.  \code{obj} must inherit class of either \code{'Schema'} or \code{'Document'}

\code{$is_scalar(name)}, \code{$is_enum(name)}, \code{$is_object(name)}, \code{$is_interface(name)}, \code{$is_union(name)}, \code{$is_input_object(name)}, \code{$is_directive(name)}, \code{$is_value(name)}: methods to determine if there is a definition of the corresponding definition type for the provided name.

\code{$get_scalar(name)}, \code{$get_enum(name)}, \code{$get_object(name)}, \code{$get_interface(name)}, \code{$get_union(name)}, \code{$get_input_object(name)}, \code{$get_directive(name)}, \code{$get_value(name)}: methods to retrieve a definition of the corresponding definition type for the provided name. If the object can't be found, \code{NULL} is returned. When printed, it quickly conveys all known information of the definition.  Due to the nature of R6 objects, definitions may be retrieved and altered after retrieval.  This is helpful for adding descriptions or resolve after the initialization.

\code{$get_scalars(name)}, \code{$get_enums(name)}, \code{$get_objects(name)}, \code{$get_interfaces(name)}, \code{$get_unions(name)}, \code{$get_input_objects(name)}, \code{$get_directives(name)}, \code{$get_values(name)}: methods to retrieve all definitions of the corresponding definition type.

\code{$get_type(name)}: method to retrieve an object of unknown type. If the object can't be found, \code{NULL} is returned. When printed, it quickly conveys all known information of the definition.

\code{$get_type(name)}: method to retrieve an object of unknown type. If the object can't be found, \code{NULL} is returned.

\code{$get_schema()}: method to retrieve full definition of schema. When printed, it quickly conveys all types in the schema.

\code{$get_query_object()}, \code{$get_mutation_object()}: helper method to retrieve the schema definition query or mutation object.

\code{$implements_interface()}: helper method to retrieve all objects who implement a particular interface.

\code{$is_valid}: boolean that determines if a Schema object has been validated.  All Schema objects are validated at the time of request execution.  The Schema will remain valid until new definitions are added.
}

\examples{
example(gqlr_schema)

}
