% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescent.MainFunction.R
\name{gradDescent.preprocessing}
\alias{gradDescent.preprocessing}
\title{The gradDescent data preprocessing function}
\usage{
gradDescent.preprocessing(dataSet, trainRate = 0.5,
  normalizationMethod = NULL, seed = NULL)
}
\arguments{
\item{dataSet}{a data frame of data that will be processed in this function.
dataSet must have at least two column (variable) and 10 row data that
contain only number (integer or float). The last column will be defined
as output variable.}

\item{trainRate}{a float value between 0 and 1 that will decide the data train
rate composition (data_length * trainRate), and the remaining rate
will set the data test rate. The default trainRate is 0.5}

\item{normalizationMethod}{this parameter determines the normalization method 
       to be used. The default normalizationMethod is NULL, which means the
       data will not be normalized.
       The method parameters that can be use:
\itemize{
\item \code{"variance"}: variance scaling method to normalize/scaling data 
                into standard score.;
\item \code{"minmax"}: minmax scaling method to scaling data into range of
                0 to 1.
}}

\item{seed}{a integer value for static random. Default value is NULL, which means 
the function will not do static random.}
}
\description{
This is one of the main function of the package This function is used to 
create a preprocessed data that can be use in the further main function.
}
\details{
This function makes the input data to be split into data train and data test
with user input of data train rate composition. After split up, both data train
and test will be normalized (if chosen) with variance or minmax scaling method.
Both data train and test will be transformed into matrix format for quick learn
process later. Finally, those data will be wrapped into a class along with 
normalization method and parameters.
}
\examples{
##################################
## I. Preprocess data with normalization
## Suppose the data have two column (input and output variable) data and  
## 10 row data that contain only number values.  
##################################   
## Data must be in data.frame form and the last column is the output
## variable. Then, set normalizationMethod value with "variance".
square_feet <- c(1400,1600,1700,1875,1100,1550,2350,2450,1425,1700)

price <- c(245,312,279,308,199,219,405,324,319,255)

house_price <- data.frame(square_feet, price)

house_price.data <- gradDescent.preprocessing(
      house_price,
      normalizationMethod="variance"
   )

##################################
## II. Preprocess data without normalization
## Suppose the data have two column (input and output variable) data and  
## 10 row data that contain only number values.  
##################################   
## Data must be in data.frame form and the last column is the output
## variable.
square_feet <- c(-0.035,0.382,0.753,1.519,-1.471,-0.275,-0.394,-0.694,-0.035,1.758)

price <- c(-0.523,0.357,-0.689,1.968,-1.453,0.423,-1.121,0.539,-0.124,0.623)

house_price <- data.frame(square_feet, price)

house_price.data <- gradDescent.preprocessing(
      house_price
   )

##################################
## III. Preprocess data with custom train rate
## Suppose the data have two column (input and output variable) data and  
## 10 row data that contain only number values.  
##################################   
## Data must be in data.frame form and the last column is the output
## variable.
square_feet <- c(-0.035,0.382,0.753,1.519,-1.471,-0.275,-0.394,-0.694,-0.035,1.758)

price <- c(-0.523,0.357,-0.689,1.968,-1.453,0.423,-1.121,0.539,-0.124,0.623)

house_price <- data.frame(square_feet, price)

house_price.data <- gradDescent.preprocessing(
      house_price,
      trainRate=0.5
   )
}

