% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scatterviolin_sc.R
\name{plot_scatterviolin_sc}
\alias{plot_scatterviolin_sc}
\title{Plot a scatter plot on a violin plot with two variables.}
\usage{
plot_scatterviolin_sc(
  data,
  xcol,
  ycol,
  colour = "ok_orange",
  symsize = 2.5,
  symthick = 1,
  bwid = 0.2,
  bvthick = 1,
  b_alpha = 1,
  v_alpha = 1,
  s_alpha = 1,
  jitter = 0,
  trim = TRUE,
  scale = "width",
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column to plot on X axis. This should be a categorical variable.}

\item{ycol}{name of the column to plot on quantitative Y axis. This should be a quantitative variable.}

\item{colour}{colour of boxes and dots; a number between 1-64, any hexcode or names from \code{grafify} colour palettes. Default is \code{ok_orange}.}

\item{symsize}{size of dots relative to \code{binwidth} used by \code{geom_point}. Default set to 2.5, increase/decrease as needed.}

\item{symthick}{thickness of dot border (\code{stroke} parameter of \code{geom_point}), default set to 1.}

\item{bwid}{width of boxplots; default 0.2}

\item{bvthick}{thickness of both violin and box plot lines; default 1.}

\item{b_alpha}{fractional opacity of boxplots, default set to 1 (i.e. maximum opacity & zero transparency). For white boxplots inside violins, set \code{b_alpha = 0}.}

\item{v_alpha}{fractional opacity of violins, default set to 1 (i.e. maximum opacity & zero transparency).  Set \code{s_alpha = 0} to not show scatter plot.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0 (i.e. aligned symbols). To reduce symbol overlap, try 0.1-0.3 or higher.}

\item{trim}{set whether tips of violin plot should be trimmed at high/low data. Default \code{trim = TRUE}, can be changed to FALSE.}

\item{scale}{set to "area" by default, can be changed to "count" or "width".}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_boxplot}, \code{ggplot2}\link{geom_point} or \code{ggplot2}\link{geom_violin}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function is related to \code{plot_scatterviolin}, but this one maps a single or same colour, therefore \verb{_sc}.
The only new argument is \code{colour}, which can be any hexcode or name of colours in the \code{all_grafify} \href{https://grafify-vignettes.netlify.app/colour_palettes.html#full-list-of-hexcodes}{palette}.
The default colour is \code{ok_orange}. \code{ColPal} and \code{ColRev} arguments are not available. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{
plot_scatterviolin_sc(data = data_doubling_time, 
xcol = Student, ycol = Doubling_time, 
colour = "ok_grey", 
symsize = 2, trim = FALSE, scale = "width")

#white boxplots and no symbols
plot_scatterviolin_sc(data = data_1w_death, 
xcol = Genotype, ycol = Death, 
colour = "pale_blue", b_alpha = 0, s_alpha = 0,
symsize = 2, trim = FALSE, scale = "width")
}
