% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xy_CatGroup.R
\name{plot_xy_CatGroup}
\alias{plot_xy_CatGroup}
\title{Plot points on a quantitative X - Y plot & a categorical grouping variable.}
\usage{
plot_xy_CatGroup(
  data,
  xcol,
  ycol,
  CatGroup,
  symsize = 2.5,
  symthick = 1,
  s_alpha = 1,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy",
    "kelly", "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  TextXAngle = 0,
  fontsize = 20,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column with quantitative X variable.}

\item{ycol}{name of the column with quantitative Y variable.}

\item{CatGroup}{a categorical variable as grouping factor for colour of data points, should be a categorical variable for default colours to work. Will be converted to \code{factor} if your column is numeric}

\item{symsize}{size of symbols used by \code{geom_point}. Default set to 2.5, increase/decrease as needed.}

\item{symthick}{thickness of symbol border, default set to 1.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{ColPal}{grafify colour palette to apply, default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_point}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, quantitative X and Y variables along with a categorical grouping variable, and a and plots a graph with using \code{\link[ggplot2]{geom_point}}. The categorical \code{CatGroup} variable is mapped to the \code{fill} aesthetic of symbols.
}
\details{
Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} (logical TRUE/FALSE) decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

This plot is related to \code{\link{plot_xy_NumGroup}} which requires a numeric grouping factor.
When summary statistics (mean/median) are required, use \code{\link{plot_3d_scatterbar}}, \code{\link{plot_3d_scatterbox}} or \code{\link{plot_4d_scatterbox}}.
}
\examples{
#The grouping factor cyl  is automatically converted to categorical variable
plot_xy_CatGroup(data = mtcars,
xcol = mpg, ycol = disp, CatGroup = cyl, 
ColPal = "vibrant", ColSeq = FALSE)
}
