% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_model.R
\name{mixed_model}
\alias{mixed_model}
\title{Model from a linear mixed effects model}
\usage{
mixed_model(data, Y_value, Fixed_Factor, Random_Factor, ...)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{Y_value}{name of column containing quantitative (dependent) variable, provided within "quotes".}

\item{Fixed_Factor}{name(s) of categorical fixed factors (independent variables) provided as a vector if more than one or within "quotes".}

\item{Random_Factor}{name(s) of random factors to allow random intercepts; to be provided as a vector when more than one or within "quotes".}

\item{...}{any additional arguments to pass on to \code{\link[lme4]{lmer}} if required.}
}
\value{
This function returns an S4 object of class "lmerModLmerTest".
}
\description{
One of four related functions for mixed effects analyses (based on \code{\link[lme4]{lmer}} and \code{\link[lmerTest]{as_lmerModLmerTest}}) to get a linear model for downstream steps, or an ANOVA table.
\enumerate{
\item \code{mixed_model}
\item \code{mixed_anova}
\item \code{mixed_model_slopes}
\item \code{mixed_anova_slopes}.
}
}
\details{
These functions require a data table, one dependent variable (Y_value), one or more independent variables (Fixed_Factor), and at least one random factor (Random_Factor). These should match names of variables in the long-format data table exactly.

Outputs of \code{mixed_model} and \code{mixed_model_slopes} can be used for post-hoc comparisons with \code{\link{posthoc_Pairwise}}, \code{\link{posthoc_Levelwise}}, \code{\link{posthoc_vsRef}}, \code{\link{posthoc_Trends_Pairwise}}, \code{\link{posthoc_Trends_Levelwise}} and \code{\link{posthoc_Trends_vsRef}}or with \code{\link[emmeans]{emmeans}}.

More than one fixed factors can be provided as a vector (e.g. c("A", "B")). A full model with interaction term is fitted.
This means when \code{Y_value = Y, Fixed_factor = c("A", "B"), Random_factor = "R"} are entered as arguments, these are passed on as \code{Y ~ A*B + (1|R)} (which is equivalent to \code{Y ~ A + B + A:B + (1|R)}).

In \code{mixed_model_slopes} and \code{mixed_anova_slopes}, the following kind of formula is used: \code{Y ~ A*B + (S|R)} (which is equivalent to \code{Y ~ A + B + A:B + (S|R)}).
In this experimental implementation, random slopes and intercepts are fitted (\code{(Slopes_Factor|Random_Factor)}). Only one term each is allowed for \code{Slopes_Factor} and \code{Random_Factor}.
}
\examples{
#one fixed factor and random factor
mixed_model(data = data_doubling_time, 
Y_value = "Doubling_time", 
Fixed_Factor = "Student", 
Random_Factor = "Experiment")

#two fixed factors as a vector, one random factor
mixed_model(data = data_cholesterol, 
Y_value = "Cholesterol", 
Fixed_Factor = c("Treatment", "Hospital"), 
Random_Factor = "Subject")

#save model
model <- mixed_model(data = data_doubling_time, 
Y_value =  "Doubling_time", 
Fixed_Factor = "Student", 
Random_Factor = "Experiment")

#get model summary
summary(model)
}
