% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winmove.R
\name{winmove}
\alias{winmove}
\title{Create moving window surface}
\usage{
winmove(dat, d, type, fun, ...)
}
\arguments{
\item{dat}{The raster dataset on which to calculate the moving window function}

\item{d}{numeric. If \code{type=circle}, the radius of the circle (in units of the CRS). If
\code{type=rectangle} the dimension of the rectangle (one or two numbers). If \code{type=Gauss}
the size of sigma, and optionally another number to determine the size of the matrix
returned (default is 3 times sigma)}

\item{type}{The shape of the moving window}

\item{fun}{The function to apply. The function fun should take multiple numbers, and
return a single number. For example mean, modal, min or max. It should also accept a
na.rm argument (or ignore it, e.g. as one of the 'dots' arguments. For example, length
will fail, but function(x, ...){na.omit(length(x))} works. See Details}

\item{...}{further arguments passed to or from other methods}
}
\value{
A smoothed raster with the moving window values calculated
}
\description{
Smooth a raster surface using a moving window with a given function, radius and shape.
}
\details{
\code{grainchanger} has several built-in functions. Functions currently
 included are: 
 \itemize{ 
  \item \code{wm_shei} - Shannon evenness, requires the additional argument \code{lc_class} (vector or scalar) 
  \item \code{wm_prop} - Proportion, requires the additional argument \code{lc_class} (scalar) 
  \item \code{wm_classes} - Unique number of classes in a categorical landscape 
  \item \code{var_range} - Range (max - min) 
}
}
\examples{
# load required data
data(cat_ls)
data(cont_ls)

# calculate the moving window mean
d = winmove(cont_ls, 5, "rectangle", "mean")

# calculate the moving window Shannon evenness
d = winmove(cat_ls, 5, "rectangle", "shei", lc_class = 0:3)

}
\keyword{focal,}
\keyword{spatial}
