% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{ComputeNtrPosteriorQuantile}
\alias{ComputeNtrPosteriorQuantile}
\alias{ComputeNtrCI}
\alias{ComputeNtrPosteriorLower}
\alias{ComputeNtrPosteriorUpper}
\title{Compute NTR quantiles}
\usage{
ComputeNtrPosteriorQuantile(data, quantile, name)

ComputeNtrCI(data, CI.size = 0.95, name.lower = "lower", name.upper = "upper")

ComputeNtrPosteriorLower(data, CI.size = 0.95, name = "lower")

ComputeNtrPosteriorUpper(data, CI.size = 0.95, name = "upper")
}
\arguments{
\item{data}{the grandR object}

\item{quantile}{which quantile to compute}

\item{name}{the name of the new slot to put quantile values in}

\item{CI.size}{A number between 0 and 1 representing the size of the credible interval}

\item{name.lower}{the name of the new slot to put the lower bound of the CI in}

\item{name.upper}{the name of the new slot to put the upper bound of the CI in}
}
\value{
a new grandR object containing an additional slot
}
\description{
Computes quantiles from the NTR posterior and puts them into a new slot
}
\details{
The NTR posterior distribution can be approximated by a beta distribution.

ComputeNtrPosteriorQuantile computes any quantile from this Beta approximation

ComputeNtrPosteriorLower computes the (1-CI.size)/2 quantile

ComputeNtrPosteriorUpper computes the 1-(1-CI.size)/2 quantile

ComputeNtrCI computes both of these quantiles.
}
\concept{preprocess}
