% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{GetContrasts}
\alias{GetContrasts}
\alias{GetContrasts.grandR}
\alias{GetContrasts.default}
\title{Create a contrast matrix}
\usage{
GetContrasts(x, ...)

\method{GetContrasts}{grandR}(
  x,
  contrast = "Condition",
  no4sU = FALSE,
  columns = NULL,
  group = NULL,
  name.format = NULL,
  ...
)

\method{GetContrasts}{default}(
  x,
  contrast,
  columns = NULL,
  group = NULL,
  name.format = NULL,
  ...
)
}
\arguments{
\item{x}{A grandR object or a column annotation table}

\item{...}{further arguments to be passed to or from other methods.}

\item{contrast}{A vector describing what should be contrasted}

\item{no4sU}{Use no4sU columns (TRUE) or not (FALSE)}

\item{columns}{logical vector of which columns (samples or cells) to use (or NULL: use all); for grandR objects, see details}

\item{group}{Split the samples or cells according to this column of the column annotation table (and adapt the of the output table)}

\item{name.format}{Format string for generating the column from the contrast vector (see details)}
}
\value{
A contrast matrix to be used in \code{\link{ApplyContrasts}}, \code{\link{LFC}}, \code{\link{PairwiseDESeq2}}
}
\description{
Each column of a contrast matrix represents a pairwise comparison of all samples or cells of
a grandR object (or a column annotation table). Elements being 1 are contrasted vs. elements being -1
(and all 0 are irrelevant for this comparison).
}
\details{
To compare one specific factor level \emph{A} against another level \emph{B} in
a particular column \emph{COL} of the column annotation table, specify contrast=c("COL","A","B")

To compare all levels against a specific level \emph{A} in
a particular column \emph{COL} of the column annotation table, specify contrast=c("COL","A")

To perform all pairwise comparisons of all levels from
a particular column \emph{COL} of the column annotation table, specify contrast=c("COL")

If the column \emph{COL} only has two levels, all three are equivalent.

In all cases, if groups is not NULL, the columns annotation table is first split and contrasts are applied within all samples or cells
with the same \emph{group} factor level.

The format string specifies the column name in the generated contrast matrix (which is used as the \emph{Analysis} name when calling
\code{\link{ApplyContrasts}}, \code{\link{LFC}}, \code{\link{PairwiseDESeq2}}, etc.). The keywords \emph{$GRP}, \emph{$COL}, \emph{$A} and \emph{$B} are substituted
by the respective elements of the contrast vector or the group this comparison refers to. By default, it is "$A vs $B" if group is NULL, and "$A vs $B.$GRP" otherwise.

The method for grandR objects simply calls the general method

For grandR objects, columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition="x").
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition","Time",Design$Replicate))

GetContrasts(sars,contrast="Condition")
# Compare all Mock vs. all SARS
GetContrasts(sars,contrast=c("Condition","SARS","Mock"))
# This direction of the comparison is more reasonable
GetContrasts(sars,contrast=c("Condition","SARS","Mock"),group="Time")
# Compare SARS vs Mock per time point
GetContrasts(sars,contrast=c("Time","no4sU"), group="Condition",no4sU=TRUE,
                                                name.format="$A vs $B ($GRP)")
# Compare each sample against the respective no4sU sample

# See the differential-expression vignette for more examples!
}
\seealso{
\code{\link{ApplyContrasts}}, \code{\link{LFC}}, \code{\link{PairwiseDESeq2}}
}
\concept{diffexp}
