% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{grandR}
\alias{grandR}
\alias{VersionString}
\alias{Title}
\alias{dim.grandR}
\alias{is.grandR}
\alias{dimnames.grandR}
\alias{print.grandR}
\alias{subset.grandR}
\alias{split.grandR}
\alias{merge.grandR}
\title{Create a grandR object and retrieve basic information}
\usage{
grandR(
  prefix = parent$prefix,
  gene.info = parent$gene.info,
  slots = parent$data,
  coldata = parent$coldata,
  metadata = parent$metadata,
  analyses = NULL,
  plots = NULL,
  parent = NULL
)

VersionString()

Title(data)

\method{dim}{grandR}(x)

is.grandR(x)

\method{dimnames}{grandR}(x)

\method{print}{grandR}(x, ...)

\method{subset}{grandR}(x, columns, ...)

\method{split}{grandR}(x, f = Design$Condition, drop = FALSE, ...)

\method{merge}{grandR}(..., list = NULL, column.name = Design$Origin)
}
\arguments{
\item{prefix}{Can either be the prefix used to call GRAND-SLAM with, or the main output file ($prefix.tsv.gz);
if the RCurl package is installed, this can also be a URL}

\item{gene.info}{a data frame with metadata for all genes}

\item{slots}{A list of matrices representing the slots}

\item{coldata}{a data frame with metadata for all samples (or cells)}

\item{metadata}{a metadata list}

\item{analyses}{the analyses list}

\item{plots}{the plots list}

\item{parent}{A parent object containing default values for all other parameters (i.e. all parameters not specified are obtained from this object)}

\item{data, x}{a grandR object}

\item{...}{further arguments to be passed to or from other methods.}

\item{columns}{which columns (i.e. samples or cells) to return (see details)}

\item{f}{The name of the annotation table according to which the object is split or the new annotation table column name denoting the origin after merging}

\item{drop}{unused}

\item{list}{a list of grandR objects}

\item{column.name}{a new name for the Coldata table to annotate the merged objects}
}
\value{
A grandR object containing the read counts, NTRs, information on the NTR posterior distribution (alpha,beta)
and potentially additional information of all genes detected by GRAND-SLAM
}
\description{
The grandR object contains
\itemize{
  \item{metadata about the origin (file/url) of the GRAND-SLAM output}
  \item{the current state (e.g., what is the current default slot) of the grandR object}
  \item{a gene info table (i.e. metadata for the rows of the data matrices)}
  \item{a column annotation table (i.e. metadata for the columns of the data matrices)}
  \item{several data matrices for read counts, normalized expression values, NTRs, etc. (genes x samples or genes x cells; stored in so-called \emph{slots})}
  \item{potentially several analysis output tables (for kinetic modeling, differential gene expression testing)}
}
Usually, this constructor is not invoked directly (but by \code{\link{ReadGRAND}} or \code{\link{SimulateTimeCourse}}).
}
\details{
The dimensions (nrow, ncol) of the grandR object are considered to be the dimensions of the data tables,
i.e. \code{nrow(data)} provides the number of genes and \code{ncol(data)} the number of samples (or cells).

Currently, the object is implemented as a list of the above mentioned items. This implementation is subject to change.
Make sure to use accessor functions to obtain the information you want.

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment havin the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\section{Functions}{

\describe{
  \item{Title}{Obtain a useful title for the project (from the prefix parameter)}
  \item{dim}{Obtain the dimensions (genes x samples or genes x cells)}
  \item{is}{Check whether it is a grandR object}
  \item{dimnames}{Obtain the row and column names of this object (genes x samples or genes x cells)}
  \item{print}{Print information on this grandR object}
  \item{subset}{Create a new grandR object with a subset of the columns (use \code{\link{FilterGenes}} to subset on genes)}
  \item{split}{Split the grandR object into a list of multiple grandR objects (according to the levels of an annotation table column)}
  \item{merge}{Merge several grandR objects into one}
}
}

\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))
# this is part of the corona data from Finkel et al.
dim(sars)
head(rownames(sars))

}
\seealso{
\link{Slots}, \link{DefaultSlot}, \link{Genes}, \link{GeneInfo}, \link{Coldata}, \link{GetTable}, \link{GetData}, \link{Analyses}, \link{GetAnalysisTable}
}
\concept{grandr}
