% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotGeneGroupsPoints}
\alias{PlotGeneGroupsPoints}
\title{Plot gene groups as points}
\usage{
PlotGeneGroupsPoints(
  data,
  gene,
  group = "Condition",
  mode.slot = DefaultSlot(data),
  columns = NULL,
  log = TRUE,
  show.CI = FALSE,
  aest = NULL,
  size = 2,
  transform = NULL
)
}
\arguments{
\item{data}{the grandR object to get the data to be plotted from}

\item{gene}{the gene to plot}

\item{group}{how to group the genes (default: Condition)}

\item{mode.slot}{the  mode.slot of the grandR object to get the data from}

\item{columns}{which columns (i.e. samples or cells) to show (see details)}

\item{log}{show the y axis in log scale}

\item{show.CI}{show confidence intervals; one of TRUE/FALSE (default: FALSE)}

\item{aest}{parameter to set the visual attributes of the plot}

\item{size}{the point size used for plotting; overridden if size is defined via aest}

\item{transform}{function that is called on the data frame directly before plotting (can be NULL)}
}
\value{
a ggplot object.
}
\description{
Plot either old, new or total RNA of a gene in a row, per condition.
}
\details{
The value of the aest parameter must be an \emph{Aesthetic mapping} as generated by \link[ggplot2]{aes}.

To refer to data slots, the mode.slot syntax can be used: Each name is either a data slot, or one of (new,old,total) followed by a
dot followed by a slot. For new or old, the data slot value is multiplied by ntr or 1-ntr. This can be used e.g. to obtain the \emph{new counts}.

The table used for plotting is the table returned by \link{GetData} with coldata set to TRUE, i.e. you can use all names from the \link{Coldata} table for aest.

By default, aest is set to aes(color=Condition,shape=Replicate) (if both Condition and Replicate are names in the Coldata table).

Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition=="x").
}
\seealso{
\link{GetData}, \link{PlotGeneTotalVsNtr},\link{PlotGeneOldVsNew},\link{PlotGeneGroupsBars}
}
\concept{geneplot}
