% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grantham_distance.R
\name{grantham_distance}
\alias{grantham_distance}
\title{Grantham distance}
\source{
\doi{10.1126/science.185.4154.862}.
}
\usage{
grantham_distance(
  x,
  y,
  method = c("original", "exact"),
  alpha = 1.833,
  beta = 0.1018,
  gamma = 0.000399,
  rho = 50.723
)
}
\arguments{
\item{x}{A character vector of amino acid three-letter codes.}

\item{y}{A character vector of amino acid three-letter codes.}

\item{method}{Either \code{"original"} (default) or \code{"exact"}, see description for
more details.}

\item{alpha}{The constant \eqn{\alpha} in the equation of Grantham's
paper, in page 863.}

\item{beta}{The constant \eqn{\beta} in the equation of Grantham's
paper, in page 863.}

\item{gamma}{The constant \eqn{\gamma} in the equation of Grantham's
paper, in page 863.}

\item{rho}{Grantham's distances reported in Table 2, Science (1974).
185(4154): 862--4 by R. Grantham, are scaled by a factor (here named
\eqn{\rho}) such that the mean value of all distances are 100. The \code{rho}
parameter allows this factor \eqn{\rho} to be changed. By default
\eqn{\rho=50.723}, the same value used by Grantham. This value is
originally mentioned in the caption of Table 2 of the aforementioned paper.}
}
\value{
A \link[tibble:tibble-package]{tibble} of Grantham's distances for each
amino acid pair.
}
\description{
This function calculates the Grantham distance for pairs of amino acids.
Amino acid identities should be provided as three-letter codes in \code{x} and
\code{y}. Amino acids identified in \code{x} and \code{y} are matched element-wise, i.e. the
first element of \code{x} is paired with the first element of \code{y}, and so on.

The Grantham distance attempts to provide a proxy for the evolutionary
distance between two amino acids based on three key chemical properties:
composition, polarity and molecular volume. In turn, evolutionary distance is
used as a proxy for the impact of missense substitutions. The higher the
distance, the more deleterious the substitution is.

The distance calculation is provided by two methods. The so-called \emph{original}
method, meaning that the amino acid distances used are the ones provided by
Grantham in his original publication in Table 2. This is the default method.
In addition, you may choose the \emph{exact} method, which uses the chemical
properties provided in Grantham's Table 1 to compute the amino acid
differences anew. The distances calculated with the \emph{exact} method are not
rounded to the nearest integer and will differ by ~1 unit for some amino acid
pairs from the \emph{original} method.

If you want to calculate Grantham's distance by providing the values of the
amino acid properties explicitly, then use \code{\link[=grantham_equation]{grantham_equation()}} instead.
}
\examples{
# Grantham's distance between Serine (Ser) and Glutamate (Glu)
grantham_distance("Ser", "Glu")

# Grantham's distance between Serine (Ser) and Glutamate (Glu)
# with the "exact" method
grantham_distance("Ser", "Glu", method = "exact")

# `grantham_distance()` is vectorised
# amino acids are paired element-wise between `x` and `y`
grantham_distance(x = c("Pro", "Gly"), y = c("Glu", "Arg"))

# Use `amino_acid_pairs()` to generate pairs (by default generates all pairs)
aa_pairs <- amino_acid_pairs()
grantham_distance(x = aa_pairs$x, y = aa_pairs$y)

}
