% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_param.R
\name{kernel_param}
\alias{kernel_param}
\title{Compute dispersal kernel parameters}
\usage{
kernel_param(p, d_disp, mode = "A")
}
\arguments{
\item{p}{A numeric value indicating the dispersal probability at a distance
equal to 'd_disp' under a negative exponential distribution.}

\item{d_disp}{A numeric value indicating the distance to which dispersal
probability is equal to 'p' under a negative exponential distribution.}

\item{mode}{A character string indicating the value to return:
\itemize{
\item{If 'mode = 'A'' (default), the returned value 'alpha' is such that
exp(-alpha * d_disp) = p}
\item{If 'mode = 'B'', the returned value 'alpha' is such that
10(-alpha * d_disp) = p}
}}
}
\value{
A numeric value
}
\description{
The function computes the constant parameters of a dispersal
kernel with a negative exponential distribution
}
\details{
If the resulting parameter when mode = "A" is a and the resulting
parameter when mode = "B" is b, then we have:
p = exp(-a.d_disp) = 10^(-b.d_disp) and a = b.ln(10)
}
\examples{
p <- 0.5
d_disp <- 3000
alpha <- kernel_param(p, d_disp, mode = "A")
}
\author{
P. Savary
}
