% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact_fraction.R
\name{if_bruzzi}
\alias{if_bruzzi}
\title{Internal:  Calculation of an impact fraction using the Bruzzi approach}
\usage{
if_bruzzi(data, ind, model, model_type, new_data, response, weight_vec)
}
\arguments{
\item{data}{A dataframe containing variables used for fitting the model}

\item{ind}{An indicator of which rows will be used from the dataset}

\item{model}{Either a clogit or glm fitted model object.  Non-linear effects should be specified via ns(x, df=y), where ns is the natural spline function from the splines library.}

\item{model_type}{Either a "clogit", "glm" or "coxph" model object}

\item{new_data}{A dataframe (of the same variables and size as data) representing an alternative distribution of risk factors}

\item{response}{A string representing the name of the outcome variable in data}

\item{weight_vec}{An optional vector of inverse sampling weights}
}
\value{
A numeric estimated impact fraction.
}
\description{
Internal:  Calculation of an impact fraction using the Bruzzi approach
}
\references{
Bruzzi, P., Green, S.B., Byar, D.P., Brinton, L.A. and Schairer, C., 1985. Estimating the population attributable risk for multiple risk factors using case-control data. American journal of epidemiology, 122(5), pp.904-914
}
