% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_PAF_continuous.R
\name{plot.PAF_q}
\alias{plot.PAF_q}
\title{Plot impact fractions corresponding to risk-quantiles over several risk factors}
\usage{
\method{plot}{PAF_q}(x, ...)
}
\arguments{
\item{x}{A PAF_q object.  This is a dataframe that is created by running the function PAF_calc_continuous.}

\item{...}{Other global arguments inherited by that might be passed to the ggplot routine}
}
\value{
A ggplot2 plotting object for PAF_q over the differing risk factors in x
}
\description{
Plot impact fractions corresponding to risk-quantiles over several risk factors
}
\examples{
library(splines)
library(survival)
library(parallel)
options(boot.parallel="snow")
options(boot.ncpus=2)
# The above could be set to the number of available cores on the machine
model_continuous <- glm(formula = case ~ region * ns(age, df = 5) +
sex * ns(age, df = 5) + education +exercise + ns(diet, df = 3) +
 alcohol + stress + ns(lipids,df = 3) + ns(waist_hip_ratio, df = 3) +
  high_blood_pressure, family = "binomial", data = stroke_reduced)
out <- PAF_calc_continuous(model_continuous,riskfactor_vec=
c("diet","lipids","waist_hip_ratio"),q_vec=c(0.1,0.9),
ci=FALSE,calculation_method="B",data=stroke_reduced)
plot(out)
\donttest{
# example with more quantile points and including confidence intervals
# (more useful - but a bit slower to run)
out <- PAF_calc_continuous(model_continuous,riskfactor_vec=
c("diet","lipids","waist_hip_ratio"),q_vec=c(0.01, 0.1,0.3,0.5,0.7,0.9),
ci=TRUE,calculation_method="B",data=stroke_reduced)
plot(out)
}
}
