% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overhaul.R
\name{gt_save}
\alias{gt_save}
\title{Save}
\usage{
gt_save(gt, file = "graphTweets.graphml", format = "graphml", ...)
}
\arguments{
\item{gt}{An object of class \code{graphTweets} as returned by \code{\link{gt_edges}}.}

\item{file}{File name including extension (\code{format}).}

\item{format}{Format file format, see \link[igraph]{write_graph}.}

\item{...}{Any other argument to pass to \link[igraph]{write_graph}.}
}
\description{
Save the graph to file.
}
\examples{
\dontrun{
# simulate dataset
tweets <- data.frame(
  text = c("I tweet @you about @him", 
           "I tweet @me about @you"),
  screen_name = c("me", "him"),
  retweet_count = c(19, 5),
  created_at = c(Sys.time(), Sys.time() + 15000),
  status_id = c(1, 2),
  stringsAsFactors = FALSE
)

tweets \%>\% 
  gt_edges(text, screen_name, "created_at") \%>\% 
  gt_nodes(TRUE) \%>\% 
  gt_dyn() \%>\% 
  gt_save()
}

}
