% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overhaul.R
\name{gt_dyn}
\alias{gt_dyn}
\title{Dynamise}
\usage{
gt_dyn(gt, lifetime = Inf)
}
\arguments{
\item{gt}{An object of class \code{graphTweets} as returned by \code{\link{gt_edges}} and \code{\link{gt_nodes}}.}

\item{lifetime}{Lifetime of a tweet in milliseconds, defaults to \code{Inf}.}
}
\description{
Create a dynamic graph to import in Gephi.
}
\examples{
\dontrun{
# simulate dataset
tweets <- data.frame(
  text = c("I tweet @you about @him and @her", 
           "I tweet @me about @you"),
  screen_name = c("me", "him"),
  created_at = c(Sys.time(), Sys.time() + 10000),
  status_id = c(1, 2),
  stringsAsFactors = FALSE
)

tweets \%>\% 
  gt_edges(text, screen_name, status_id, "created_at") \%>\% 
  gt_nodes() \%>\% 
  gt_dyn() \%>\% 
  gt_collect() -> net
}

}
