% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_completions_general.R
\name{complete_Gamma_general}
\alias{complete_Gamma_general}
\title{Non-decomposable completion of variogram matrices}
\usage{
complete_Gamma_general(
  Gamma,
  graph,
  N = 10000,
  tol = get_large_tol(),
  check_tol = 100
)
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{graph}{\code{igraph::graph()} object.}

\item{N}{Maximum number of iterations.}

\item{tol}{Numeric scalar. Tolerance to be used when completing submatrices.}

\item{check_tol}{Numeric/integer scalar. How often to check the tolerance when completing submatrices.}
}
\value{
A completed \dxd variogram matrix.
}
\description{
Given a non-decomposable \code{graph}, and (non-graphical) variogram matrix \code{Gamma},
modifies \code{Gamma} in non-edge entries, such that the resulting matrix is a
variogram matrix with graphical structure described by \code{graph}.
}
\seealso{
Other matrix completion related topics:
\code{\link{complete_Gamma_decomposable}()},
\code{\link{complete_Gamma_general_demo}()},
\code{\link{complete_Gamma_general_split}()},
\code{\link{complete_Gamma}()}
}
\concept{matrixCompletions}
