% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_p.R
\name{adjust_p_bonferroni}
\alias{adjust_p_bonferroni}
\alias{adjust_p_parametric}
\alias{adjust_p_simes}
\title{Calculate adjusted p-values}
\usage{
adjust_p_bonferroni(p, hypotheses)

adjust_p_parametric(
  p,
  hypotheses,
  test_corr = NULL,
  maxpts = 25000,
  abseps = 1e-06,
  releps = 0
)

adjust_p_simes(p, hypotheses)
}
\arguments{
\item{p}{A numeric vector of p-values (unadjusted, raw), whose values should
be between 0 & 1. The length should match the length of \code{hypotheses}.}

\item{hypotheses}{A numeric vector of hypothesis weights. Must be a vector of
values between 0 & 1 (inclusive). The length should match the length of
\code{p}. The sum of hypothesis weights should not exceed 1.}

\item{test_corr}{(Optional) A numeric matrix of correlations between test
statistics, which is needed to perform parametric tests using
\code{\link[=adjust_p_parametric]{adjust_p_parametric()}}. The number of rows and columns of
this correlation matrix should match the length of \code{p}.}

\item{maxpts}{(Optional) An integer scalar for the maximum number of function
values, which is needed to perform parametric tests using the
\code{mvtnorm::GenzBretz} algorithm. The default is 25000.}

\item{abseps}{(Optional) A numeric scalar for the absolute error tolerance,
which is needed to perform parametric tests using the \code{mvtnorm::GenzBretz}
algorithm. The default is 1e-6.}

\item{releps}{(Optional) A numeric scalar for the relative error tolerance
as double, which is needed to perform parametric tests using the
\code{mvtnorm::GenzBretz} algorithm. The default is 0.}
}
\value{
A single adjusted p-value for the intersection hypothesis.
}
\description{
For an intersection hypothesis, an adjusted p-value is the smallest
significance level at which the intersection hypothesis can be rejected.
The intersection hypothesis can be rejected if its adjusted p-value is less
than or equal to \eqn{\alpha}. Currently, there are three test types
supported:
\itemize{
\item Bonferroni tests for \code{\link[=adjust_p_bonferroni]{adjust_p_bonferroni()}},
\item Parametric tests for \code{\link[=adjust_p_parametric]{adjust_p_parametric()}},
\itemize{
\item Note that one-sided tests are required for parametric tests.
}
\item Simes tests for \code{\link[=adjust_p_simes]{adjust_p_simes()}}.
}
}
\examples{
hypotheses <- c(H1 = 0.5, H2 = 0.25, H3 = 0.25)
p <- c(0.019, 0.025, 0.05)
adjust_p_bonferroni(p, hypotheses)
set.seed(1234)
hypotheses <- c(H1 = 0.5, H2 = 0.25, H3 = 0.25)
p <- c(0.019, 0.025, 0.05)
# Using the `mvtnorm::GenzBretz` algorithm
corr <- matrix(0.5, nrow = 3, ncol = 3)
diag(corr) <- 1
adjust_p_parametric(p, hypotheses, corr)
hypotheses <- c(H1 = 0.5, H2 = 0.25, H3 = 0.25)
p <- c(0.019, 0.025, 0.05)
adjust_p_simes(p, hypotheses)
}
\references{
Bretz, F., Maurer, W., Brannath, W., and Posch, M. (2009). A graphical
approach to sequentially rejective multiple test procedures.
\emph{Statistics in Medicine}, 28(4), 586-604.

Lu, K. (2016). Graphical approaches using a Bonferroni mixture of weighted
Simes tests. \emph{Statistics in Medicine}, 35(22), 4041-4055.

Xi, D., Glimm, E., Maurer, W., and Bretz, F. (2017). A unified framework
for weighted parametric multiple test procedures.
\emph{Biometrical Journal}, 59(5), 918-931.
}
\seealso{
\code{\link[=adjust_weights_parametric]{adjust_weights_parametric()}} for adjusted hypothesis weights using
parametric tests, \code{\link[=adjust_weights_simes]{adjust_weights_simes()}} for adjusted hypothesis weights
using Simes tests.
}
