% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backbone_function.R, R/layouts.R
\name{backbone_layout}
\alias{backbone_layout}
\alias{layout_as_backbone}
\alias{layout_igraph_backbone}
\title{Backbone graph layout}
\usage{
layout_as_backbone(g, keep = 0.2, backbone = T)

layout_igraph_backbone(g, keep = 0.2, backbone = T, circular)
}
\arguments{
\item{g}{igraph object}

\item{keep}{fraction of edges to keep in backbone calculation}

\item{backbone}{logical. Return edge ids of the backbone}

\item{circular}{not used}
}
\value{
coordinates to be used layouting a graph
}
\description{
emphasizes a hidden group structure if it exists in the graph
}
\details{
the layout_igraph_* function should not be used directly. It is only used as an Argument for 'ggraph'.
}
\examples{
 library(igraph)
 library(ggraph)

 g <- sample_islands(9,20,0.4,9)
 g <- simplify(g)
 V(g)$grp <- as.character(rep(1:9,each=20))
 bb <- layout_as_backbone(g,keep=0.4)
 E(g)$col <- FALSE
 E(g)$col[bb$backbone] <- TRUE

 ggraph(g,layout="manual",node.positions=data.frame(x=bb$xy[,1],y=bb$xy[,2]))+
   geom_edge_link(aes(col=col),width=0.1,n=2)+
   geom_node_point(aes(col=grp))+
   scale_color_brewer(palette = "Set1")+
   scale_edge_color_manual(values=c(rgb(0,0,0,0.3),rgb(0,0,0,1)))+
   theme_graph()+
   theme(legend.position = "none")

}
\references{
Nocaj, A., Ortmann, M., & Brandes, U. (2015). Untangling the hairballs of multi-centered, small-world online social media networks. Journal of Graph Algorithms and Applications: JGAA, 19(2), 595-618.
}
