% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_umap.R, R/layouts.R
\name{layout_umap}
\alias{layout_umap}
\alias{layout_with_umap}
\alias{layout_igraph_umap}
\title{UMAP graph layouts}
\usage{
layout_with_umap(g, pivots = NULL, ...)

layout_igraph_umap(g, circular, ...)
}
\arguments{
\item{g}{igraph object}

\item{pivots}{if not NULL, number of pivot nodes to use for distance calculation (for large graphs).}

\item{...}{additional parameters for umap. See the \code{?uwot::umap} for help.}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
Using the UMAP dimensionality reduction algorithm as a graph layout
}
\details{
The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'. UMAP can be tuned by many different parameters. Refer to the documentation at https://github.com/jlmelville/uwot for help
}
\examples{
library(igraph)

g <- sample_islands(10,20,0.6,10)
xy <- layout_with_umap(g,min_dist = 0.5)
}
\references{
McInnes, Leland, John Healy, and James Melville. "Umap: Uniform manifold approximation and projection for dimension reduction." arXiv preprint arXiv:1802.03426 (2018).
}
\author{
David Schoch
}
