% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.SBA.R
\name{est.SBA}
\alias{est.SBA}
\title{Estimate graphons based on Stochastic Blockmodel approximation}
\usage{
est.SBA(A, delta = 0.5)
}
\arguments{
\item{A}{either \describe{
\item{Case 1.}{an \eqn{(n\times n)} binary adjacency matrix, or}
\item{Case 2.}{a vector containing multiple of \eqn{(n\times n)} binary adjacency matrices.}
}}

\item{delta}{a precision parameter larger than 0.}
}
\value{
a named list containing
\describe{
\item{H}{a \eqn{(K\times K)} matrix fo 3D histogram.}
\item{P}{an \eqn{(n\times n)} corresponding probability matrix.}
\item{B}{a length-\eqn{K} list where each element is a vector of nodes/indices
for each cluster.}
}
}
\description{
\code{est.SBA} takes a 2-stage approach for estimating graphons
based on exchangeable random graph models. First, it finds a
Stochastic Blockmodel Approximation (SBA) of the graphon. Then,
it uses clustering information to estimate graphon using a consistent
 histogram estimator.
}
\examples{
## generate a graphon of type No.6 with 3 clusters
W = gmodel.preset(3,id=6)

## create a probability matrix for 100 nodes
graphW = gmodel.block(W,n=100)
P = graphW$P

## draw 17 observations from a given probability matrix
A = gmodel.P(P,rep=17)

## run SBA algorithm with different deltas (0.2,0.5,0.8)
res2 = est.SBA(A,delta=0.2)
res3 = est.SBA(A,delta=0.5)
res4 = est.SBA(A,delta=0.8)

## compare true probability matrix and estimated ones
opar <- par(mfrow=c(2,2), pty="s")
image(P); title("original P")
image(res2$P); title("SBA with delta=0.2")
image(res3$P); title("SBA with delta=0.5")
image(res4$P); title("SBA with delta=0.8")
par(opar)

}
\references{
\insertRef{Airoldi2013}{graphon}

\insertRef{chan2014}{graphon}
}
\seealso{
\code{\link{est.LG}}
}
