% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.nbdsmooth.R
\name{est.nbdsmooth}
\alias{est.nbdsmooth}
\title{Estimate edge probabilities by neighborhood smoothing}
\usage{
est.nbdsmooth(A)
}
\arguments{
\item{A}{either \describe{
\item{Case 1.}{an \eqn{(n\times n)} binary adjacency matrix, or}
\item{Case 2.}{a vector containing multiple of \eqn{(n\times n)} binary adjacency matrices.}
}}
}
\value{
a named list containing
\describe{
\item{h}{a quantile threshold value.}
\item{P}{a matrix of estimated edge probabilities.}
}
}
\description{
\code{est.nbdsmooth} takes the expectation of the adjacency matrix
in that it directly aims at estimating network edge probabilities without
imposing structural assumptions as of usual graphon estimation requires,
such as piecewise lipschitz condition. Note that this method is
for symmetric adjacency matrix only, i.e., undirected networks.
}
\examples{
## generate a graphon of type No.4 with 3 clusters
W = gmodel.preset(3,id=4)

## create a probability matrix for 100 nodes
graphW = gmodel.block(W,n=100)
P = graphW$P

## draw 5 observations from a given probability matrix
A = gmodel.P(P,rep=5,symmetric.out=TRUE)

## run nbdsmooth algorithm
res2 = est.nbdsmooth(A)

## compare true probability matrix and estimated ones
opar <- par(mfrow=c(1,2), pty="s")
image(P, main="original P matrix")
image(res2$P, main="nbdsmooth estimated P")
par(opar)

}
\references{
\insertRef{Zhang2015}{graphon}
}
