\name{grasp.options}
\alias{grasp.options}
\title{ Internal GRASP function}
\description{
 Set main GRASP options
}
\usage{
grasp.options(title = "GRASP: ", path = "c:/temp", plotpar = c(3, 3), npast = 0,
selxlim = gr.selX, corlim = 100, corplot = TRUE, nbar = 10, df1 = 0, df2 = 4, test = "F", plimit = 0.05, direction = "both", weights = FALSE, mincont = 0, startwith = gr.selX,
resetstart = TRUE, showdetail = FALSE, cvgroups = 5, 
resolution = (max(XXXpred$CX) - min(XXXpred$CX))/(length(unique(XXXpred$CX)) - 1), 
StdError = TRUE)
}
\arguments{
  \item{title}{Title in the plots}
  \item{path}{path where outputs will be written}
  \item{plotpar}{A vector of the number of colonnes and lines in plots}
  \item{npast}{For limits, the number of data to be left out (limited)}
  \item{selxlim}{For limits, a vector of predictors to which limits will be applied}
  \item{corlim}{...}
  \item{corplot}{If true, correlation will be plotted}
  \item{nbar}{Number of bars in histograms}
  \item{df1}{First degrees of freedom}
  \item{df2}{Second degrees of freedom}
  \item{test}{Wich test to use, F-test by default}
  \item{plimit}{...}
  \item{direction}{...}
  \item{weights}{If TRUE, weights will be used, they are stored in the WEIGHTS dataframe generated by grasp.in}
  \item{mincont}{...}
  \item{startwith}{...}
  \item{resetstart}{...}
  \item{showdetail}{...}
  \item{cvgroups}{...}
  \item{resolution}{...}
  \item{StdError}{...}
}
\author{ Anthony.Lehmann@unige.ch }
\seealso{ grasp \code{\link{grasp}}, grasp.in \code{\link{grasp.in}}}
\keyword{models}