% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-utils.R
\name{link}
\alias{link}
\alias{link.family}
\alias{link.gam}
\alias{link.bam}
\alias{link.gamm}
\alias{link.glm}
\alias{link.list}
\alias{inv_link}
\alias{inv_link.family}
\alias{inv_link.gam}
\alias{inv_link.bam}
\alias{inv_link.gamm}
\alias{inv_link.list}
\alias{inv_link.glm}
\alias{extract_link}
\alias{extract_link.family}
\alias{extract_link.general.family}
\title{Extract link and inverse link functions from models}
\usage{
link(object, ...)

\method{link}{family}(object, parameter = NULL, which_eta = NULL, ...)

\method{link}{gam}(object, parameter = NULL, which_eta = NULL, ...)

\method{link}{bam}(object, parameter = NULL, which_eta = NULL, ...)

\method{link}{gamm}(object, ...)

\method{link}{glm}(object, ...)

\method{link}{list}(object, ...)

inv_link(object, ...)

\method{inv_link}{family}(object, parameter = NULL, which_eta = NULL, ...)

\method{inv_link}{gam}(object, parameter = NULL, which_eta = NULL, ...)

\method{inv_link}{bam}(object, parameter = NULL, which_eta = NULL, ...)

\method{inv_link}{gamm}(object, ...)

\method{inv_link}{list}(object, ...)

\method{inv_link}{glm}(object, ...)

extract_link(family, ...)

\method{extract_link}{family}(family, inverse = FALSE, ...)

\method{extract_link}{general.family}(family, parameter, inverse = FALSE, which_eta = NULL, ...)
}
\arguments{
\item{object}{a family object or a fitted model from which to extract the
family object.  Models fitted by \code{\link[stats:glm]{stats::glm()}}, \code{\link[mgcv:gam]{mgcv::gam()}},
\code{\link[mgcv:bam]{mgcv::bam()}}, \code{\link[mgcv:gamm]{mgcv::gamm()}}, and \code{\link[gamm4:gamm4]{gamm4::gamm4()}} are currently
supported.}

\item{...}{arguments passed to other methods.}

\item{parameter}{character; which parameter of the distribution. Usually
\code{"location"} but \code{"scale"} and \code{"shape"} may be provided for location
scale models. Other options include \code{"mu"} as a synonym for \code{"location"},
\code{"sigma"} for the scale parameter in \code{\link[mgcv:gaulss]{mgcv::gaulss()}}, \code{"pi"} for the
zero-inflation term in \code{\link[mgcv:ziplss]{mgcv::ziplss()}}, \code{"power"} for the
\code{\link[mgcv:twlss]{mgcv::twlss()}} power parameter, \code{"xi"}, the shape parameter for
\code{\link[mgcv:gevlss]{mgcv::gevlss()}}, \code{"epsilon"} or \code{"skewness"} for the skewness and
\code{"delta"} or \code{"kurtosis"} for the kurtosis parameter for
\code{\link[mgcv:shash]{mgcv::shash()}}, or \code{"theta"} for the scale parameter of \code{\link[mgcv:gammals]{mgcv::gammals()}}.}

\item{which_eta}{numeric; the linear predictor to extract for families
\code{\link[mgcv:mvn]{mgcv::mvn()}} and \code{\link[mgcv:multinom]{mgcv::multinom()}}.}

\item{family}{a family object, the result of a call to \code{\link[=family]{family()}}.}

\item{inverse}{logical; return the inverse of the link function?}
}
\description{
Returns the link or its inverse from an estimated model, and provides a
simple way to extract these functions from complex models with multiple
links, such as location scale models.
}
\examples{
load_mgcv()

link(gaussian())
link(nb())

inv_link(nb())

dat <- data_sim("eg1", seed = 4234)
mod <- gam(list(y ~ s(x0) + s(x1) + s(x2) + s(x3), ~ 1), data = dat,
           family = gaulss)

link(mod, parameter = "scale")
inv_link(mod, parameter = "scale")

## Works with `family` objects too
link(shash(), parameter = "skewness")
}
\author{
Gavin L. Simpson
}
