% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.difference_smooth}
\alias{draw.difference_smooth}
\title{Plot differences of smooths}
\usage{
\method{draw}{difference_smooth}(
  object,
  select = NULL,
  rug = FALSE,
  ref_line = FALSE,
  contour = FALSE,
  contour_col = "black",
  n_contour = NULL,
  ci_alpha = 0.2,
  ci_col = "black",
  smooth_col = "black",
  line_col = "red",
  scales = c("free", "fixed"),
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  angle = NULL,
  ...
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{rug}{logical;}

\item{ref_line}{logical;}

\item{contour}{logical; should contour lines be added to smooth surfaces?}

\item{contour_col}{colour specification for contour lines.}

\item{n_contour}{numeric; the number of contour bins. Will result in
\code{n_contour - 1} contour lines being drawn. See \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{ci_alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{ci_col}{colour specification for the confidence/credible intervals
band. Affects the fill of the interval.}

\item{smooth_col}{colour specification for the the smooth or difference line.}

\item{line_col}{colour specicification for drawing reference lines}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? If \code{scales = "free"}, the default, each univariate
smooth has its own y-axis scale. If \code{scales = "fixed"}, a common y axis
scale is used for all univariate smooths.

Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{xlab, ylab, title, subtitle, caption}{character; labels with which to
annotate plots}

\item{angle}{numeric; the angle at which the x axis tick labels are to be
drawn passed to the \code{angle} argument of \code{\link[ggplot2:guide_axis]{ggplot2::guide_axis()}}.}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\description{
Plot differences of smooths
}
\examples{

load_mgcv()
# simulate some data; a factor smooth example
df <- data_sim("eg4", seed = 42)
# fit GAM
m <- gam(y ~ fac + s(x2, by = fac) + s(x0), data = df, method = "REML")

# calculate the differences between pairs of smooths the f_j(x2) term
diffs <- difference_smooths(m, smooth = "s(x2)")
draw(diffs)
}
