% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concurvity.R
\name{model_concurvity}
\alias{model_concurvity}
\alias{model_concurvity.gam}
\alias{concrvity}
\title{Concurvity of an estimated GAM}
\usage{
model_concurvity(model, ...)

\method{model_concurvity}{gam}(
  model,
  terms = everything(),
  type = c("all", "estimate", "observed", "worst"),
  pairwise = FALSE,
  ...
)

concrvity(
  model,
  terms = everything(),
  type = c("all", "estimate", "observed", "worst"),
  pairwise = FALSE,
  ...
)
}
\arguments{
\item{model}{a fitted GAM. Currently only objects of class \code{"gam"} are
supported}

\item{...}{arguents passed to other methods.}

\item{terms}{currently ignored}

\item{type}{character;}

\item{pairwise}{logical; extract pairwise concurvity of model terms?}
}
\description{
Concurvity of an estimated GAM
}
\examples{
## simulate data with concurvity...
library("tibble")
load_mgcv()
set.seed(8)
n <- 200
df <- tibble(t = sort(runif(n)),
             x = gw_f2(t) + rnorm(n) * 3,
             y = sin(4 * pi * t) + exp(x / 20) + rnorm(n) * 0.3)

## fit model
m <- gam(y ~ s(t, k = 15) + s(x, k = 15), data = df, method = "REML")

## overall concurvity
o_conc <- concrvity(m)
draw(o_conc)

## pairwise concurvity
p_conc <- concrvity(m, pairwise = TRUE)
draw(p_conc)
}
