% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{worm_plot}
\alias{worm_plot}
\alias{worm_plot.gam}
\alias{worm_plot.glm}
\alias{worm_plot.lm}
\title{Worm plot of model residuals}
\usage{
worm_plot(model, ...)

\method{worm_plot}{gam}(
  model,
  method = c("uniform", "simulate", "normal", "direct"),
  type = c("deviance", "response", "pearson"),
  n_uniform = 10,
  n_simulate = 50,
  level = 0.9,
  ylab = NULL,
  xlab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ci_col = "black",
  ci_alpha = 0.2,
  point_col = "black",
  point_alpha = 1,
  line_col = "red",
  ...
)

\method{worm_plot}{glm}(model, ...)

\method{worm_plot}{lm}(model, ...)
}
\arguments{
\item{model}{a fitted model. Currently only class \code{"gam"}.}

\item{...}{arguments passed ot other methods.}

\item{method}{character; method used to generate theoretical quantiles. Note
that \code{method = "direct"} is deprecated in favour of \code{method = "uniform"}.}

\item{type}{character; type of residuals to use. Only \code{"deviance"},
\code{"response"}, and \code{"pearson"} residuals are allowed.}

\item{n_uniform}{numeric; number of times to randomize uniform quantiles
in the direct computation method (\code{method = "uniform"}).}

\item{n_simulate}{numeric; number of data sets to simulate from the estimated
model when using the simulation method (\code{method = "simulate"}).}

\item{level}{numeric; the coverage level for reference intervals. Must be
strictly \verb{0 < level < 1}. Only used with \code{method = "simulate"}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{xlab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}. May be a vector, one per penalty.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}. May be a vector, one per penalty.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}. May be a vector, one per penalty.}

\item{ci_col}{fill colour for the reference interval when
\code{method = "simulate"}.}

\item{ci_alpha}{alpha transparency for the reference
interval when \code{method = "simulate"}.}

\item{point_col}{colour of points on the QQ plot.}

\item{point_alpha}{alpha transparency of points on the QQ plot.}

\item{line_col}{colour used to draw the reference line.}
}
\description{
Worm plot of model residuals
}
\note{
The wording used in \code{\link[mgcv:qq.gam]{mgcv::qq.gam()}} uses \emph{direct} in reference to the
simulated residuals method (\code{method = "simulated"}). To avoid confusion,
\code{method = "direct"} is deprecated in favour of \code{method = "uniform"}.
}
\examples{
load_mgcv()
## simulate binomial data...
dat <- data_sim("eg1", n = 200, dist = "binary", scale = .33, seed = 0)
p <- binomial()$linkinv(dat$f) # binomial p
n <- sample(c(1, 3), 200, replace = TRUE) # binomial n
dat <- transform(dat, y = rbinom(n, n, p), n = n)
m <- gam(y / n ~ s(x0) + s(x1) + s(x2) + s(x3),
  family = binomial, data = dat, weights = n,
  method = "REML"
)

## Worm plot; default using direct randomization of uniform quantiles
## Note no reference bands are drawn with this method.
worm_plot(m)

## Alternatively use simulate new data from the model, which
## allows construction of reference intervals for the Q-Q plot
worm_plot(m,
  method = "simulate", point_col = "steelblue",
  point_alpha = 0.4
)

## ... or use the usual normality assumption
worm_plot(m, method = "normal")
}
