% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmixmorm.R
\name{rmixnorm}
\alias{rmixnorm}
\title{Generate random variables from a mixture of multivariate normal distributions}
\usage{
rmixnorm(n, means, sigmas, weights)
}
\arguments{
\item{n}{an integer for the number of samples to be generated.}

\item{means}{a q x k matrix (or a vector of length k if q=1) containing the means for each component.}

\item{sigmas}{a q x q x k covariance array (or a vector of length k if q=1) for each component.}

\item{weights}{a vector of length k containing the weights for each component.}
}
\value{
An n x q matrix (or a vector if q=1) containing the generated data.
}
\description{
Random variables from a mixture of k multivariate normal distributions, each of dimension q.
}
\examples{
out <- rmixnorm(
  n = 1000, means = c(-5, 0, 5), sigmas = c(1, 1, 3),
  weights = c(0.3, 0.4, 0.3)
)
hist(out, breaks = 100, freq = FALSE)
}
\references{
Villani et al 2009.
}
\author{
Feng Li, Central University of Finance and Economics.
}
