% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_child_care_subsidy.R
\name{model_child_care_subsidy}
\alias{model_child_care_subsidy}
\title{Model Child Care Subsidy}
\usage{
model_child_care_subsidy(
  sample_file,
  Cbdc_hourly_cap = NULL,
  Fdc_hourly_cap = NULL,
  Oshc_hourly_cap = NULL,
  Ihc_hourly_cap = NULL,
  Annual_cap_income = NULL,
  Annual_cap_subsidy = NULL,
  Income_test_bracket_1 = NULL,
  Income_test_bracket_2 = NULL,
  Income_test_bracket_3 = NULL,
  Income_test_bracket_4 = NULL,
  Income_test_bracket_5 = NULL,
  Taper_1 = NULL,
  Taper_2 = NULL,
  Taper_3 = NULL,
  Activity_test_1_brackets = NULL,
  Activity_test_1_hours = NULL,
  calc_baseline_ccs = TRUE,
  return. = c("sample_file", "new_ccs", "sample_file.int")
)
}
\arguments{
\item{sample_file}{A sample file having the same variables as the data.frame in the example.}

\item{Cbdc_hourly_cap, Fdc_hourly_cap, Oshc_hourly_cap, Ihc_hourly_cap}{(numeric) The lower of `cost_hour` or the relevant `hourly_cap` will be used in the calculation of the subsidy.}

\item{Annual_cap_income}{(numeric) The minimum family income for which the `Annual_cap_subsidy` applies from.}

\item{Annual_cap_subsidy}{(numeric) Amount at which annual subsidies are capped for those who earn more than `Annual_cap_income`.}

\item{Income_test_bracket_1, Income_test_bracket_2, Income_test_bracket_3, Income_test_bracket_4, Income_test_bracket_5}{(numeric) The steps at which income test 1 changes rates. Note the strange structure \url{https://www.humanservices.gov.au/individuals/services/centrelink/child-care-subsidy/payments/how-your-income-affects-it}.}

\item{Taper_1, Taper_2, Taper_3}{(numeric) The proportion of the hourly cap retained. Note that the rate only decreases between each odd bracket.}

\item{Activity_test_1_brackets}{(numeric vector) The activity levels at which the activity test increases.}

\item{Activity_test_1_hours}{(numeric vector) The hours corresponding to the step increase in `activity_test_1_brackets`.}

\item{calc_baseline_ccs}{(logical, default: \code{TRUE}) Should the current child care subsidy be included as a column in the result?}

\item{return.}{What should the function return? One of \code{subsidy}, \code{sample_file}, or \code{sample_file.int}. 
If \code{subsidy}, the subsidy received under the settings; if \code{sample_file}, the \code{sample_file},
but with variables \code{subsidy} and possibly \code{new_subsidy}; if \code{sample_file.int}, same as \code{sample_file} but \code{new_subsidy} is coerced to integer.}
}
\description{
The child care subsidy if thresholds and rates are changed.
 (See \code{\link{child_care_subsidy}}.)
}
