% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raster-class.R, R/array-class.R,
%   R/grec-internal.R, R/grec-main.R
\name{detectFronts.RasterLayer}
\alias{detectFronts.RasterLayer}
\alias{detectFronts.array}
\alias{detectFronts.default}
\alias{detectFronts}
\title{Detection of fronts based on gradient recognition}
\usage{
\method{detectFronts}{RasterLayer}(x, qLimits = c(0.9, 0.99),
  finalSmooth = FALSE, intermediate = FALSE, control = list())

\method{detectFronts}{array}(x, qLimits = c(0.9, 0.99), finalSmooth = FALSE,
  intermediate = FALSE, control = list())

\method{detectFronts}{default}(x, qLimits = c(0.9, 0.99),
  finalSmooth = FALSE, intermediate = FALSE, control = list())

detectFronts(x, qLimits = c(0.9, 0.99), finalSmooth = FALSE,
  intermediate = FALSE, control = list())
}
\arguments{
\item{x}{Main input of class \code{matrix}, \code{list}, \code{RasterLayer} or \code{array}. See 'Details.'}

\item{qLimits}{\code{numeric} vector of length 1 or 2 with info of limits of values to consider. See 'Details'.}

\item{finalSmooth}{\code{logical} indicating whether to apply a smooth to final matrix so as to remove noise.}

\item{intermediate}{\code{logical} indicating whether to get the intermediate matrices (\code{TRUE})
or just the final one (\code{FALSE}).}

\item{control}{A \code{list} of control parameters for filter application See 'Details'.}
}
\value{
Depending of input class of \code{x}, the output will preserve its class.
}
\description{
This function takes a environmental map (as a numeric matrix) and allows the user to idenitify
the gradients by using of sobel filters.
}
\details{
Inspired by the algorithm described on Belkin & O'Reilly (2009), this function performs 4 steps:
\enumerate{
\item Smoothing of the original data by a median filter application.
\item Application of sobel filters horizontally (sobelH) and vertically (sobelV).
\item Extract gradients, using the formula \eqn{sqrt(sobelH^2 + sobelV^2)}.
\item Removing noise signals using a median filter, from \code{imagine} package.
}

\code{x} could be given as a single numeric matrix containing the values of a
environmental map. Othersiwe it also can be a list with dimensions 'x', 'y' and 'z' specifying
the dimensions of the data as follows: 'x' will be a numeric vector with the values of longitude,
'y' will indicate the latitude (numeric vector as well). 'grec' package is not rigorous in
the check of the values given for dimensions, so the user must be carefull with them.

\code{x} can be specified as a \code{RasterLayer} or \code{array} object. If \code{x} is an \code{array}, it
must have 3 dimensions: lon, lat and time. It is not required to specify the \code{dimnames}. The output will
preserve all the attributes and the order of input.

\code{qLimits} works after the extraction of grandient matrix. Values of these matrix are vectorized
and the quantiles indicated on \code{qLimits} are taken (that is the reason of the argument name). Then
the values out of the limits are replaced by \code{NA}. \code{qLimits} could be given as a single value.
If so, the second value must be calculated as \code{c(qLimits, qLimits + (1 - qLimits)/2)}.

The control argument is a list that allows the (advanced) users modify some aspects of filter
application. The parameters of \code{control} are given to functions of \code{\link{imagine}} package.
It must be a \code{list} including the following named objects:
\describe{
\item{\strong{firstSmooth}}{Arguments (\code{radius} and \code{times}) pased to \code{\link{medianFilter}}
function, used for apply the smoothing to the original matrix. It must be given as a named list.}
\item{\strong{sobelStrength}}{Number that multiplies \code{qLimits} vector. It is usefull to highlight
the differences.}
\item{\strong{clearNoise}}{Arguments (\code{radius} and \code{times}) pased to \code{\link{medianFilter}}
function, used for apply the median-filter for cleaning noise and getting the output matrix. It must be
given as a named list.}
}
}
\examples{
load(system.file("extdata", "exampleSSTData.RData", package = "grec"))
out <- detectFronts(x = exampleSSTData)
image(out, col = colPalette)
}
\references{
Belkin, I. M., & O'Reilly, J. E. (2009). An algorithm for oceanic front detection in chlorophyll
and SST satellite imagery. Journal of Marine Systems, 78(3), 319-326
(\url{http://dx.doi.org/10.1016/j.jmarsys.2008.11.018}).
}
