% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assigncluster.R
\name{assign.cluster}
\alias{assign.cluster}
\title{Assign clusters to a new vector of categories}
\usage{
assign.cluster(x, clusters, impute = FALSE)
}
\arguments{
\item{x}{a factor or character vector representing a categorical variable}

\item{clusters}{a named numeric vector of cluster numbers, such as an
object returned by \code{\link{greencut}} or \code{\link{cutree}}}

\item{impute}{a boolean controlling the behavior when a value in \code{x}
is not found in \code{names(clusters)} (see Details).}
}
\value{
A factor vector of the same length as \code{x}, representing
  assigned cluster numbers.
}
\description{
Maps a vector of cluster numbers to another categorical vector,
yielding a new vector of matching cluster numbers. Useful for distributing
cluster numbers back out to the original observations in cases where the
clustering was performed on a table of unique levels rather than directly
on the observations (such as with \code{\link{greenclust}}).
}
\details{
Any categories in \code{x} that do not exist in \code{names(clusters)}
are given a cluster of \code{NA}, or (if \code{impute} is \code{TRUE})
assigned the cluster number that is most-frequently used for the other
existing categories, with ties going to the lowest cluster number. If
there are no matching clusters for any of the categories in \code{x},
imputation will simply use the first cluster number in \code{clusters}.

If there are duplicate names in \code{clusters}, the first occurrence
takes precedence.
}
\examples{
# Cluster feed types based on number of "underweight" chicks
grc <- greenclust(table(chickwts$feed,
                        ifelse(chickwts$weight < 200, "Y", "N")))
# Assign clusters to each original observation
feed.clustered <- assign.cluster(chickwts$feed, greencut(grc))
table(chickwts$feed, feed.clustered)
}
\seealso{
\code{\link{greenclust}}, \code{\link{greencut}},
    \code{\link{greenplot}}
}
