% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ensure_date_format}
\alias{ensure_date_format}
\title{Check date format and transform in a usable one}
\usage{
ensure_date_format(date_input)
}
\arguments{
\item{date_input}{Date included as input}
}
\value{
A character string representing the date in 'YYYY-MM-DD' format
}
\description{
Check date format. If the format is wrong ('NA') an error message is printed,
    else it will formatted the date in the correct way (YYYY-MM-DD)
}
\examples{
# Example of correct date formats
ensure_date_format("2024-08-30") # "2024-08-30"
ensure_date_format("08/30/2024") # "2024-08-30"
ensure_date_format("30/08/2024") # "2024-08-30"

# Example of incorrect date formats
tryCatch(
  {
    ensure_date_format("Aug-30")
  },
  error = function(e) {
    message(e$message)
  }
)

}
\keyword{internal}
