% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grex.R
\name{grex}
\alias{grex}
\title{Gene ID Mapping for Genotype-Tissue Expression (GTEx) Data}
\usage{
grex(ensembl_id)
}
\arguments{
\item{ensembl_id}{Character vector of Ensembl IDs}
}
\value{
This function returns a data frame with the
same number of rows as the length of input Ensembl IDs, containing:
\itemize{
\item \code{ensembl_id} - Input Ensembl ID
\item \code{entrez_id} - Entrez Gene ID
\item \code{hgnc_symbol} - HGNC gene symbol
\item \code{hgnc_name} - HGNC gene name
\item \code{cyto_loc} - Cytogenetic location
\item \code{uniprot_id} - UniProt ID
}
The elements that cannot be mapped will be \code{NA}.
}
\description{
Map Ensembl IDs to Entrez Gene ID, HGNC symbol, and UniProt ID.
}
\examples{
# Ensembl IDs in GTEx v6 gene count data
data("gtexv6")
# select 100 IDs as example
id = gtexv6[101:200]
df = grex(id)
# show Ensembl IDs which have a mapped Entrez ID
df[!is.na(df$entrez_id), c('ensembl_id', 'entrez_id')]
}

