% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combiner.R
\name{combiner}
\alias{combiner}
\title{Combine regressions based on information criteria}
\usage{
combiner(data, ic = c("AICc", "AIC", "BIC"), bruteForce = FALSE,
  silent = TRUE)
}
\arguments{
\item{data}{Data frame containing dependant variable in the first column and
the others in the rest.}

\item{ic}{Information criterion to use.}

\item{bruteForce}{If \code{TRUE}, then all the possible models are generated
and combined. Otherwise the best model is found and then models around that
one are produced and then combined.}

\item{silent}{If \code{FALSE}, then nothing is silent, everything is printed
out. \code{TRUE} means that nothing is produced.}
}
\value{
Function returns \code{model} - the final model of the class
"lm.combined".
}
\description{
Function combines parameters of linear regressions of the first variable
on all the other provided data.
}
\details{
The algorithm uses lm() to fit different models and then combines the models
based on the selected IC.
}
\examples{

### Simple example
xreg <- cbind(rnorm(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
inSample <- xreg[1:80,]
outSample <- xreg[-c(1:80),]
# Combine all the possible models
ourModel <- combiner(inSample,bruteForce=TRUE)
forecast(ourModel,outSample)
plot(forecast(ourModel,outSample))

### Fat regression example
xreg <- matrix(rnorm(5000,10,3),50,100)
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rnorm(50,0,3),xreg,rnorm(50,300,10))
colnames(xreg) <- c("y",paste0("x",c(1:100)),"Noise")
inSample <- xreg[1:40,]
outSample <- xreg[-c(1:40),]
# Combine only the models close to the optimal
ourModel <- combiner(inSample,ic="AICc",bruteForce=FALSE)
summary(ourModel)
plot(forecast(ourModel,outSample))

}
\references{
\itemize{
\item Burnham Kenneth P. and Anderson David R. (2002). Model Selection
and Multimodel Inference. A Practical Information-Theoretic Approach.
Springer-Verlag New York. \url{http://dx.doi.org/10.1007/b97636}.
}
}
\seealso{
\code{\link[stats]{step}, \link[greybox]{xregExpander},
\link[greybox]{stepwise}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
