% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_tuning.R
\name{tune_regression_forest}
\alias{tune_regression_forest}
\title{Regression forest tuning}
\usage{
tune_regression_forest(X, Y, num.fit.trees = 10, num.fit.reps = 100,
  num.optimize.reps = 1000, min.node.size = NULL, sample.fraction = 0.5,
  mtry = NULL, alpha = NULL, imbalance.penalty = NULL,
  num.threads = NULL, honesty = TRUE, seed = NULL, clusters = NULL,
  samples_per_cluster = NULL)
}
\arguments{
\item{X}{The covariates used in the regression.}

\item{Y}{The outcome.}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model.}

\item{num.fit.reps}{The number of forests used to fit the tuning model.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{honesty}{Whether or not honest splitting (i.e., sub-sample splitting) should be used.}

\item{seed}{The seed for the C++ random number generator.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.}

\item{samples_per_cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster.}
}
\value{
A list consisting of the optimal parameter values ('params') along with their debiased
        error ('error').
}
\description{
Finds the optimal parameters to be used in training a regression forest. This method
currently tunes over min.node.size, mtry, sample.fraction, alpha, and imbalance.penalty.
Please see the method 'regression_forest' for a description of the standard forest
parameters. Note that if fixed values can be supplied for any of the parameters mentioned
above, and in that case, that parameter will not be tuned. For example, if this method is
called with min.node.size = 10 and alpha = 0.7, then those parameter values will be treated
as fixed, and only sample.fraction and imbalance.penalty will be tuned.
}
\examples{
\dontrun{
# Find the optimal tuning parameters.
n = 500; p = 10
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
params = tune_regression_forest(X, Y)$params

# Use these parameters to train a regression forest.
tuned.forest = regression_forest(X, Y, num.trees = 1000,
    min.node.size = as.numeric(params["min.node.size"]),
    sample.fraction = as.numeric(params["sample.fraction"]),
    mtry = as.numeric(params["mtry"]),
    alpha = as.numeric(params["alpha"]),
    imbalance.penalty = as.numeric(params["imbalance.penalty"]))
}

}
