% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_all_values.R
\name{estimate_all_values}
\alias{estimate_all_values}
\title{Estimate All Values}
\usage{
estimate_all_values(
  input_df,
  distribution,
  wrt_option_lift,
  priors = list(),
  wrt_option_vr = NULL,
  loss_threshold = 0.95,
  lift_threshold = 0.7,
  metric = "lift"
)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}

\item{wrt_option_lift}{String: the option lift and win probability is calculated
with respect to (wrt). Required.}

\item{priors}{Optional list of priors. Defaults will be use otherwise.}

\item{wrt_option_vr}{String: the option against which loss (value remaining)
is calculated. If NULL the best option will be used. (optional)}

\item{loss_threshold}{The confidence interval specifying what the "worst case scenario" should be.
Defaults to 95\%. (optional)}

\item{lift_threshold}{The confidence interval specifying how likely the lift is to be true.
Defaults to 70\%. (optional)}

\item{metric}{string the type of loss.
absolute will be the difference, on the outcome scale. 0 when best = wrt_option
lift will be the (best - wrt_option) / wrt_option, 0 when best = wrt_option
relative_risk will be the ratio best/wrt_option, 1 when best = wrt_option}
}
\value{
A list with 4 named items: Win Probability, Value Remaining,
    Lift vs Baseline, and Win Probability vs Baseline.
}
\description{
Efficiently estimates all values at once so the posterior only need to be
sampled one time. This function will return as a list win probability,
value remaining, estimated percent lift with respect to the provided option,
and the win probability of the best option vs the provided option.
}
\details{
TODO: Add high density credible intervals to this output for each option.
}
\examples{
\donttest{
input_df <- data.frame(option_name = c("A", "B", "C"),
    sum_clicks = c(1000, 1000, 1000),
    sum_conversions = c(100, 120, 110))
estimate_all_values(input_df, distribution = "conversion_rate", wrt_option_lift = "A")
}

}
