#' responseReturn
#'
#' @param raw the chatresponse to return
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by the LLM.
#'
#'
responseReturn <- function(raw) {

  # 'raw' data is written to the clipboard
  clipr::write_clip(paste(raw, sep = "\n"), allow_non_interactive = TRUE)
  # 'raw' is returned without any modification
  return(raw)
}
